<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// word
Route::post('/word/search', [\App\Http\Controllers\Api\DictionaryController::class, 'search']);
Route::post('/word/save', [\App\Http\Controllers\Api\DictionaryController::class, 'save']);
Route::post('/word/edit', [\App\Http\Controllers\Api\DictionaryController::class, 'edit']);
Route::post('/word/get/{word_id}', [\App\Http\Controllers\Api\DictionaryController::class, 'get']);
Route::post('/word/update', [\App\Http\Controllers\Api\DictionaryController::class, 'update']);
Route::post('/word/delete/{word}', [\App\Http\Controllers\Api\DictionaryController::class, 'delete']);

// category
Route::post('/cat/save', [\App\Http\Controllers\Api\CategoryController::class, 'save']);
Route::post('/cat/get/{id}', [\App\Http\Controllers\Api\CategoryController::class, 'getWithId']);
Route::post('/cat/search', [\App\Http\Controllers\Api\CategoryController::class, 'search']);
Route::any('/cat/all', [\App\Http\Controllers\Api\CategoryController::class, 'all']);
Route::post('/cat/update/{cat_id}', [\App\Http\Controllers\Api\CategoryController::class, 'update']);



Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
