<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Jenssegers\Mongodb\Eloquent\Model;

class Translation extends Model
{
    use HasFactory;

    protected $connection = 'mongodb';
    protected $collection = 'translations';
    public $timestamps = false;
    protected $fillable = [
        'fa_word',
        'en_word',
        'category',
        'status',
        'image',
        'voice'
    ];

    public function getWord()
    {
        return $this->hasMany(Translation::class, 'en_word', 'en_word');
    }
}
