<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\WordResource;
use App\Models\Translation;
use App\Models\Word;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DictionaryController extends Controller
{
    public function search(Request $request): \Illuminate\Http\JsonResponse
    {
        $translations = Translation::orderBy('en_word')->get();
        if (request('search') != null && request('search')['value'] != null) {
            $translations =  Translation::where('en_word', 'LIKE', '%' . $request->search['value'] . '%')->orderBy('en_word')->get();
        }
        return response()->json([
            'list' => WordResource::collection($translations)
        ]);
        if ($request->exists('search') && request('search') != '') {
            $search = request('search');
            $translations = [];
            if (request('lang') == config('constants.dictionary.lang.fa_lang')) {
                $translations = Translation::where('fa_word', 'LIKE', '%' . $search . '%')->orderBy('fa_word')->get();
            } elseif (request('lang') == config('constants.dictionary.lang.en_lang')) {
                $translations = Translation::where('en_word', 'LIKE', '%' . $search . '%')->orderBy('en_word')->get();
            }
            return response()->json([
                'list' => $translations
            ]);
        } else {
            /*$translations = [];
            if (request('lang') == config('constants.dictionary.lang.fa_lang')) {
                $translations = Translation::orderBy('fa_word')->get();
            } elseif (request('lang') == config('constants.dictionary.lang.en_lang')) {
                $translations = Translation::orderBy('en_word')->get();
            }*/
            $translations = Translation::orderBy('en_word')->get();
            return response()->json([
                'data' => $translations
            ]);
        }
    }

    public function save(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required'
        ], [
            'title.required' => 'عنوان انگلیسی را وارد کنید.'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->messages()->all(),
                'keys' => $validator->messages()->keys()
            ], 400);
        }
        if ($request->exists('translations') && request('translations') != '' && request('translations') != null) {
            $rows = json_decode(request('translations'), true);
            if (count($rows) == 0) {
                return response()->json(['message' => 'لطفا ترجمه(ها) را وارد کنید'], 400);
            }
            foreach ($rows as $translate) {
                $this->englishWord($translate);
            }
            return response()->json('عملیات با موفقیت انجام شد.', 200);
        } else {
            return response()->json(['message' => 'لطفا ترجمه(ها) را وارد کنید'], 400);
        }
    }

    public function edit(Request $request): \Illuminate\Http\JsonResponse
    {
        $words = [];
        if (request('lang') == config('constants.dictionary.lang.fa_lang')) {
            $translations = Translation::where('fa_word', request('word'))->orderBy('fa_word')->get();
            $cats = $translations->unique('category')->map(function ($translation) {
                return ['category' => $translation->category];
            });
            foreach ($cats as $index => $category) {
                $words[$index] = [
                    'category' => $category['category']
                ];
                foreach ($translations as $translation) {
                    if ($translation->category == $category['category']) {
                        $words[$index]['words'][] = $translation->en_word;
                    }
                }
            }
        } elseif (request('lang') == config('constants.dictionary.lang.en_lang')) {
            $translations = Translation::where('en_word', request('word'))->orderBy('en_word')->get();
            $cats = $translations->unique('category')->map(function ($translation) {
                return ['category' => $translation->category];
            });
            foreach ($cats as $index => $category) {
                $words[$index] = [
                    'category' => $category['category']
                ];
                foreach ($translations as $translation) {
                    if ($translation->category == $category['category']) {
                        $words[$index]['words'][] = $translation->fa_word;
                    }
                }
            }
        }

        return response()->json(['translations' => $words, 'lang' => request('lang'), 'word' => request('word'), 'original' => $translations ?? null]);
    }

    public function update(Request $request): \Illuminate\Http\JsonResponse
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required'
        ], [
            'title.required' => 'عنوان انگلیسی را وارد کنید.'
        ]);
        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->messages()->all(),
                'keys' => $validator->messages()->keys()
            ], 400);
        }
        if (!$request->exists('new_translations') || request('new_translations') == '' || count(json_decode(request('new_translations'), true)) == 0) {
            return response()->json(['message' => 'لطفا ترجمه(ها) را وارد کنید'], 400);
        }
        Translation::where('en_word', request('previous_title'))->delete();
        foreach (json_decode(request('new_translations'), true) as $newTranslate) {
            $this->englishWord($newTranslate);
        }
        return response()->json(['message' => 'عملیات با موفقیت انجام شد.', 'url' => request('back_url')], 200);
    }

    private function customValidate()
    {
        /*if (!request()->exists('title') || request('title') == null || request('title') == '') {
            return response()->json(['message' => 'عنوان انگلیسی را وارد کنید'], 400);
        }*/

    }

    private function farsiWord($data)
    {
        $translation = Translation::where('fa_word', $data['word'])
            ->where('en_word', $data['translate'])
            ->where('category', $data['category'])
            ->first();

        if ($translation == null) {
            $translation = new Translation();
            $translation->category = $data['category'];
            $translation->fa_word = $data['word'];
            $translation->en_word = $data['translate'];
            $translation->save();
        }
    }

    private function englishWord($data)
    {
        $translation = Translation::where('en_word', $data['title'])
            ->where('fa_word', $data['translate'])
            ->where('category', $data['category'])
            ->first();

        if ($translation == null) {
            $translation = new Translation();
            $translation->category = $data['category'];
            $translation->en_word = $data['title'];
            $translation->fa_word = $data['translate'];
            $translation->image = $data['image'];
            $translation->voice = $data['voice'];
            $translation->status = $data['status'] == '1' ? 1 : 0;
            $translation->save();
        }
    }

    public function get($word): \Illuminate\Http\JsonResponse
    {
        $translations = Translation::whereEnWord($word)->get();
        if ($translations->count() > 0) {
            return response()->json([
                'word' => $word,
                'translations' => $translations
            ]);
        } else {
            return response()->json(['message' => 'لغت مورد نظر یافت نشد!'], 400);
        }
    }

    public function delete($word)
    {
        Translation::where('en_word', $word)->delete();
        return response()->json(['message' => 'واژه حذف شد.'], 200);
    }
}
